﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Net;
using System.Text;
using System.IO;

namespace SendSmsDemo_web
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            TextBox4.Text = DateTime.Now.ToString("yyyyMMddHHmmss");//大写HH表示24小时制时间
        }

        protected void Button2_Click(object sender, EventArgs e)
        {//查询余额
            string param = "userid=企业ID&account=短信账号&password=密码";
            byte[] bs = Encoding.UTF8.GetBytes(param);

            HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create("http://cloud.thinksms.cn/sms.aspx?action=overage");//编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，防止乱码，详见接口文档说明
            req.Method = "POST";
            req.ContentType = "application/x-www-form-urlencoded";
            req.ContentLength = bs.Length;

            using (Stream reqStream = req.GetRequestStream())
            {
                reqStream.Write(bs, 0, bs.Length);
            }
            using (WebResponse wr = req.GetResponse())
            {
                StreamReader sr = new StreamReader(wr.GetResponseStream(), System.Text.Encoding.Default);
                TextBox3.Text = sr.ReadToEnd().Trim();
            }
        }

        protected void Button3_Click(object sender, EventArgs e)
        {//发送短信
		//企业ID（userid），登陆后台：http://cloud.thinksms.cn 通过“客户管理”-“我的信息”查询。
            string param = "action=send&userid=企业ID&account=短信账号&password=密码&content=" + TextBox2.Text + "&mobile=" + TextBox1.Text;
            byte[] bs = Encoding.UTF8.GetBytes(param);

            HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create("http://cloud.thinksms.cn/sms.aspx"); //编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，防止乱码，详见接口文档说明
            req.Method = "POST";
            req.ContentType = "application/x-www-form-urlencoded";
            req.ContentLength = bs.Length;

            using (Stream reqStream = req.GetRequestStream())
            {
                reqStream.Write(bs, 0, bs.Length);
            }
            using (WebResponse wr = req.GetResponse())
            {
                StreamReader sr = new StreamReader(wr.GetResponseStream(), System.Text.Encoding.Default);
                TextBox3.Text = sr.ReadToEnd().Trim();
            }
        }
    }
}
/*	

接入注意事项：（常见问题）
1.内容乱码						------->>>>>> 编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，如两个提交入口均乱码，重新转换一下文件编码。
2.提示短信必须带【】格式签名	------->>>>>> 提交入口不正确导致乱码，系统识别不到【】签名；或发送短信时未带前缀签名；
3.返回错误0						------->>>>>> 定时短信sendtime格式错误，sendtime可为空或具体时间，不能传0
4.程序异常，请重试或联系客服！从字符串转换日期和/或时间时，转换失败。------->>>>>> 定时短信sendtime格式错误，sendtime可为空或具体时间
			
*/