package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
)

// 短信发送返回结果结构体（用于注释说明，实际解析可使用 map 或此结构体）
type SmsResponse struct {
	ReturnStatus   string `json:"ReturnStatus"`   // 返回状态：Success 或 Faild
	Message        string `json:"Message"`        // 返回信息说明
	RemainPoint    int    `json:"RemainPoint"`    // 剩余点数
	TaskID         int    `json:"TaskID"`         // 任务ID
	SuccessCounts  int    `json:"SuccessCounts"`  // 成功发送条数
}

func main() {
	// 配置参数（请替换为实际值）
	userid := "你的企业ID"
	account := "你的短信账号"
	password := "你的密码"
	mobile := "13800138000,15900159000" 			// 多个号码用英文逗号分隔
	content := "【智想云创】您的注册验证码：8899"		// 注意开头必须带签名

	// 构建请求参数
	params := url.Values{}
	params.Set("userid", userid)
	params.Set("account", account)
	params.Set("password", password)
	params.Set("mobile", mobile)
	params.Set("content", content)
	params.Set("action", "send")
	params.Set("rt", "json") // 指定返回JSON格式

	// 发送HTTP POST请求
	resp, err := http.PostForm("http://cloud.thinksms.cn/sms.aspx", params)
	if err != nil {
		fmt.Println("请求失败:", err)
		return
	}
	defer resp.Body.Close()

	// 读取响应体
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		fmt.Println("读取响应失败:", err)
		return
	}

	// 输出原始JSON响应
	fmt.Println("原始响应:", string(body))

	// 可选：解析JSON并注释说明（仅供开发者参考，实际业务中可进一步处理）
	var result SmsResponse
	if err := json.Unmarshal(body, &result); err != nil {
		fmt.Println("解析JSON失败:", err)
		return
	}

	// 注释方式展示解析结果
	fmt.Printf("\n解析结果说明:\n")
	fmt.Printf("ReturnStatus: %s （成功返回 Success，失败返回 Faild）\n", result.ReturnStatus)
	fmt.Printf("Message: %s （返回信息说明）\n", result.Message)
	fmt.Printf("RemainPoint: %d （剩余短信条数）\n", result.RemainPoint)
	fmt.Printf("TaskID: %d （本次任务ID）\n", result.TaskID)
	fmt.Printf("SuccessCounts: %d （成功发送条数）\n", result.SuccessCounts)
}