package com.sms.interfacej;

import java.net.URLEncoder;

import com.sms.tool.SmsClientAccessTool;

/**
 * <p>
 * <date>2012-03-01</date><br/>
 * <span>提供的JAVA接口信息（短信，彩信）调用API</span><br/>
 * <span>----------查询状态报告--只允许查取一次-------------</span>
 * </p>
 * 
 * @author LIP
 * @version 1.0.1
 */
public class SmsClientQueryStatusReport {

	/**
	 * <p>
	 * <date>2012-03-01</date><br/>
	 * <span>状态报告获取方法1--必须传入必填内容</span><br/>
	 * <p>
	 * 其一：发送方式，默认为POST<br/>
	 * 其二：发送内容编码方式，默认为UTF-8
	 * </p>
	 * <br/>
	 * </p>
	 * 
	 * @param url
	 *            ：必填--发送连接地址URL--比如>http://cloud.thinksms.cn/statusApi.aspx  编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，详见接口文档说明
	 * @param userid
	 *            ：必填--企业ID（userid）登陆后台：http://cloud.thinksms.cn 通过“客户管理”-“我的信息”查询。
	 * @param account
	 *            ：必填--用户帐号
	 * @param password
	 *            ：必填--用户密码
	 * @return 返回状态报告
	 */
	public static String queryStatusReport(String url, String userid,
			String account, String password) {

		try {
			StringBuffer sendParam = new StringBuffer();
			sendParam.append("action=query");
			sendParam.append("&userid=").append(userid);
			sendParam.append("&account=").append(
					URLEncoder.encode(account, "UTF-8"));
			sendParam.append("&password=").append(
					URLEncoder.encode(password, "UTF-8"));

			return SmsClientAccessTool.getInstance().doAccessHTTPPost(url,
					sendParam.toString(), "UTF-8");
		} catch (Exception e) {
			e.printStackTrace();
			return "未发送，异常-->" + e.getMessage();
		}
	}
}
