import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SmsSender {

    // 短信接口URL（UTF-8编码）
    private static final String SMS_URL = "http://cloud.thinksms.cn/sms.aspx";

    public static void main(String[] args) {
        // 配置参数（请替换为实际值）
        String userid = "你的企业ID";
        String account = "你的短信账号";
        String password = "你的密码";
        String mobile = "13800138000,15900159000"; // 多个号码用英文逗号分隔
        String content = "【智想云创】您的注册验证码：8899"; // 注意签名在前

        // 发送短信
        String result = sendSms(userid, account, password, mobile, content);
        System.out.println("接口返回结果：" + result);

        // 解析返回值（注释说明）
        // 成功示例：{"ReturnStatus":"Success","Message":"ok","RemainPoint":109346,"TaskID":365,"SuccessCounts":2}
        // ReturnStatus: 成功为"Success"，失败为"Faild"
        // Message: 返回信息，如"ok"表示成功
        // RemainPoint: 剩余短信条数
        // TaskID: 任务ID
        // SuccessCounts: 成功发送的短信条数
    }

    public static String sendSms(String userid, String account, String password, 
                                 String mobile, String content) {
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = null;

        try {
            // 构建请求参数
            String params = "action=send&rt=json" +
                    "&userid=" + URLEncoder.encode(userid, "UTF-8") +
                    "&account=" + URLEncoder.encode(account, "UTF-8") +
                    "&password=" + URLEncoder.encode(password, "UTF-8") +
                    "&mobile=" + URLEncoder.encode(mobile, "UTF-8") +
                    "&content=" + URLEncoder.encode(content, "UTF-8") +
                    "&extno="; // 扩展子号，若无请留空

            // 创建HTTP连接
            URL url = new URL(SMS_URL);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(params.length()));

            // 发送请求
            try (OutputStream os = conn.getOutputStream()) {
                os.write(params.getBytes(StandardCharsets.UTF_8));
            }

            // 读取响应
            try (BufferedReader reader = new BufferedReader(
                    new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            return "请求异常: " + e.getMessage();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        return response.toString();
    }
}