import org.json.JSONObject;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SmsSender {

    /**
     * 发送短信
     * @param userid 企业ID，登录控制台获取
     * @param account API账号，登录控制台获取
     * @param password API密码，登录控制台获取
     * @param mobile 接收的手机号；多个手机号使用英文逗号间隔
     * @param content 短信内容（必须包含签名）
     */
    public static void sendSMS(String userid, String account, String password, 
                              String mobile, String content) {
        try {
            // 构建请求参数
            String params = "action=send&rt=json" +
                    "&userid=" + URLEncoder.encode(userid, StandardCharsets.UTF_8) +
                    "&account=" + URLEncoder.encode(account, StandardCharsets.UTF_8) +
                    "&password=" + URLEncoder.encode(password, StandardCharsets.UTF_8) +
                    "&mobile=" + URLEncoder.encode(mobile, StandardCharsets.UTF_8) +
                    "&content=" + URLEncoder.encode(content, StandardCharsets.UTF_8) +
                    "&extno=";

            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create("http://cloud.thinksms.cn/sms.aspx"))
                    .header("Content-Type", "application/x-www-form-urlencoded")
                    .POST(HttpRequest.BodyPublishers.ofString(params))
                    .build();

            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            
            // 输出原始返回结果
            System.out.println("返回结果: " + response.body());
            
            // 解析返回值示例（注释说明）
            /*
            成功返回示例：
            {
                "ReturnStatus": "Success",   // 成功状态
                "Message": "ok",             // 返回消息
                "RemainPoint": 100,          // 剩余条数
                "TaskID": 12345,             // 任务ID
                "SuccessCounts": 2           // 成功发送数量
            }
            
            失败返回示例：
            {
                "ReturnStatus": "Faild",
                "Message": "用户名或密码错误"
            }
            */

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        // 测试发送
        sendSMS(
            "你的企业ID",          // userid
            "你的短信账号",        // account
            "你的密码",           // password
            "13800138000,15900159000", // mobile
            "【智想云创】您的注册验证码：8899" // content（注意签名在前）
        );
    }
}