import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * 余额及已发送量查询接口
 * 对应文档：第二章 余额及已发送量查询接口
 */
public class BalanceQuery {

    private static final String QUERY_URL = "http://cloud.thinksms.com/sms.aspx";
    private static final String USER_ID = "your_user_id";   //（登录后台->客户管理->我的信息）查询企业ID
    private static final String ACCOUNT = "your_account";   // 替换为实际值
    private static final String PASSWORD = "your_password"; // 替换为实际值

    public static void main(String[] args) {
        String result = queryBalance();
        System.out.println("接口返回结果: " + result);

        /*
         * ==================== 返回值解析 ====================
         *
         * 成功示例：
         * {"ReturnStatus":"Success","Message":"","Payinfo":"后付费","Overage":109346,"SendTotal":1075}
         *
         * 字段说明：
         * - ReturnStatus: Success 表示查询成功
         * - Message: 错误信息（为空表示成功）
         * - Payinfo: 支付方式，"后付费" 或 "预付费"
         * - Overage: 当前剩余短信条数
         * - SendTotal: 总发送量（预付费时为总充值点数）
         *
         * 常见错误：
         * {"ReturnStatus":"Faild","Message":"用户名或密码错误"}
         * {"ReturnStatus":"Faild","Message":"用户名或密码不能为空"}
         *
         * ===================================================
         */
    }

    public static String queryBalance() {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            StringBuilder params = new StringBuilder();
            params.append("action=overage")
                  .append("&rt=json")
                  .append("&userid=").append(URLEncoder.encode(USER_ID, StandardCharsets.UTF_8))
                  .append("&account=").append(URLEncoder.encode(ACCOUNT, StandardCharsets.UTF_8))
                  .append("&password=").append(URLEncoder.encode(PASSWORD, StandardCharsets.UTF_8));

            URL url = new URL(QUERY_URL + "?" + params);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(false);

            int responseCode = conn.getResponseCode();
            reader = new BufferedReader(new InputStreamReader(
                responseCode == 200 ? conn.getInputStream() : conn.getErrorStream(),
                StandardCharsets.UTF_8
            ));

            StringBuilder response = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            return response.toString();

        } catch (Exception e) {
            return "{\"ReturnStatus\":\"Faild\",\"Message\":\"" + e.getMessage() + "\"}";
        } finally {
            if (conn != null) conn.disconnect();
            try { if (reader != null) reader.close(); } catch (Exception ignored) {}
        }
    }
}