<?php
/**
 * 获取短信回复（上行）功能示例
 * 
 * 该脚本演示如何使用企信通大客户HTTP2.0接口获取用户对短信的回复（上行消息）。
 * 根据文档，需要调用特定的callApi地址，并构造包含userid, timestamp, sign参数的POST请求，
 * action参数固定为'query'。
 * 注意：相同的上行回复只能获取一次。
 * 
 * 注意：请将 YOUR_USERID, YOUR_USERNAME, YOUR_PASSWORD 替换为实际的账户信息。
 */

// ------------------------ 配置区域 ------------------------

$userid = 'YOUR_USERID';        // 企业ID（登陆后台-客户管理-我的信息）
$username = 'YOUR_USERNAME';    // 账号
$password = 'YOUR_PASSWORD';    // 密码
// ---------------------------------------------------------

// 获取当前时间戳 (格式: YYYYMMDDHHMMSS)
$timestamp = date('YmdHis');

// 根据文档说明，生成接口密钥 sign
// sign = MD5(账号 + 密码 + 时间戳)，32位小写
$signString = $username . $password . $timestamp;
$sign = md5($signString);

// 准备POST请求数据
$postData = [
    'userid'    => $userid,
    'timestamp' => $timestamp,
    'sign'      => $sign,
    'action'    => 'query', // 固定值
    'rt'        => 'json'   // 指定返回JSON格式
];

// 上行接口（短信回复）地址
$url = 'http://cloud.thinksms.cn/v2callApi.aspx';

// 初始化cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

// 执行请求并获取响应
$response = curl_exec($ch);

// 输出原始返回值
echo $response;

// 关闭cURL句柄
curl_close($ch);
?>