<?php
/**
 * 文件: get_report.php
 * 功能: 获取短信发送状态报告功能
 * 编码: 此接口URL固定，与内容编码无关
 */

require_once 'sms_common.php';

/**
 * 获取短信发送状态报告
 * @param string $userid 企业ID（登录后台->客户管理->我的信息）
 * @param string $account 短信账号
 * @param string $password 登录密码
 * @param int $statusNum 每次获取的号码数量 (默认4000)
 * @return array 接口返回结果，包含状态报告数组
 */
function sms_get_report($userid, $account, $password, $statusNum = 4000) {
    $params = sms_get_base_params($userid, $account, $password, 'query');
    $params['statusNum'] = $statusNum;
    
    $url = 'http://cloud.thinksms.cn/statusApi.aspx';
    
    return sms_send_request($url, $params);
}

// --- 使用示例 ---
/*
$reports = sms_get_report('your_userid', 'your_account', 'your_password');
print_r($reports);
*/
?>