<?php
/**
 * 文件: send_sms.php
 * 功能: 发送短信功能
 * 编码: 支持UTF-8和GBK，默认UTF-8
 */

require_once 'sms_common.php';

/**
 * 发送短信
 * @param string $userid 企业ID（登录后台->客户管理->我的信息）
 * @param string $account 短信账号
 * @param string $password 登录密码
 * @param string|array $mobile 接收号码，支持单个号码或数组
 * @param string $content 短信内容 (需包含签名，如【智想云创】)
 * @param string $sendTime 定时发送时间 (格式：YYYY-MM-DD HH:MM:SS)，为空则立即发送
 * @param string $extno 扩展子号 (可选)
 * @param bool $useGbk 是否使用GBK编码 (默认false，使用UTF-8)
 * @return array 接口返回结果
 */
function sms_send($userid, $account, $password, $mobile, $content, $sendTime = '', $extno = '', $useGbk = false) {
    // 格式化手机号
    if (is_array($mobile)) {
        $mobile = implode(',', $mobile);
    }
    
    $params = sms_get_base_params($userid, $account, $password, 'send');
    $params['mobile'] = $mobile;
    $params['content'] = $content;
    $params['sendTime'] = $sendTime;
    $params['extno'] = $extno;
    
    $baseUrl = $useGbk ? 'http://cloud.thinksms.cn/smsGBK.aspx' : 'http://cloud.thinksms.cn/sms.aspx';
    
    return sms_send_request($baseUrl, $params);
}

// --- 使用示例 ---
/*
$result = sms_send('your_userid', 'your_account', 'your_password', '13800138000', '【智想云创】您的注册验证码：1234');
print_r($result);
*/
?>