<?php
/**
 * 文件: sms_common.php
 * 功能: 短信接口公共函数
 * 包含发送请求和构建基础参数的通用函数
 */

/**
 * 发送HTTP POST请求并返回JSON解码结果
 * @param string $url 请求地址
 * @param array $params POST参数
 * @return array 解码后的响应数组
 */
function sms_send_request($url, $params) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

/**
 * 构建基础请求参数
 * @param string $userid 企业ID（登录后台->客户管理->我的信息）
 * @param string $account 账号
 * @param string $password 密码
 * @param string $action 操作类型 (send, overage, checkkeyword, changespwd)
 * @return array 基础参数数组
 */
function sms_get_base_params($userid, $account, $password, $action) {
    return [
        'userid' => $userid,
        'account' => $account,
        'password' => $password,
        'action' => $action,
        'rt' => 'json'
    ];
}