<?php
/**
 * 状态报告查询接口
 */

// 配置参数
$userid = '你的企业ID';		//（登录后台->客户管理->我的信息）查询企业ID
$account = '你的短信账号'; 
$password = '你的密码';
$statusUrl = 'http://cloud.Thinksms.com/statusApi.aspx'; // 状态报告接口地址

// 构建请求参数
$data = [
    'action' => 'query',
    'rt' => 'json',
    'userid' => $userid,
    'account' => $account,
    'password' => $password,
    'statusNum' => 4000 // 每次获取的状态报告数量,最小为10
];

// 发送HTTP请求
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $statusUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
curl_close($ch);

// 输出原始返回值
echo $response;

/*
返回值解析说明：
{
    "ReturnStatus": "Success",       // 返回状态值：Success 成功, Faild 失败
    "Message": "OK",                 // 描述信息
    "Task": [                        // 状态报告数组
        {
            "Mobile": "13800138000", // 手机号码
            "TaskID": "358",         // 任务ID
            "Status": "20",          // 状态：10-发送成功，20-发送失败
            "ReceiveTime": "2018-08-20 11:20:18", // 接收时间
            "ErrorCode": "UNDELIVERED", // 返回代码（参考值）
            "ExtNo": ""              // 扩展子号
        }
    ]
}

Status状态说明：
- 10: 发送成功
- 20: 发送失败
?>