<?php
/**
 * 上行回复查询接口（用户回复的短信）
 */

// 配置参数
$userid = '你的企业ID';	 //（登录后台->客户管理->我的信息）查询企业ID
$account = '你的短信账号';
$password = '你的密码';
$moUrl = 'http://cloud.Thinksms.com/callApi.aspx'; // 上行接口地址

// 构建请求参数
$data = [
    'action' => 'query',
    'rt' => 'json',
    'userid' => $userid,
    'account' => $account,
    'password' => $password,
    'ownExt' => '' // 使用自有扩展号，为空或1
];

// 发送HTTP请求
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $moUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
curl_close($ch);

// 输出原始返回值
echo $response;

/*
返回值解析说明：
{
    "ReturnStatus": "Success",       // 返回状态值：Success 成功, Faild 失败
    "Message": "OK",                 // 描述信息
    "Task": [                        // 上行回复数组
        {
            "Mobile": "136",         // 手机号码
            "TaskID": "1",           // 任务ID
            "Content": "test",       // 回复内容
            "ReceiveTime": "2018-12-07 15:17:26", // 接收时间
            "ExtNo": "251251"        // 扩展子号
        }
    ]
}

错误返回值：
{
    "ReturnStatus": "Faild",
    "Message": "用户名或密码错误"
}

注意事项：
- 相同的上行回复只能获取一次
- ownExt参数：当值为1时，返回的extno将剔除系统强制附加的子号
*/
?>