<?php
/**
 * 短信接口主类
 * 支持UTF-8和GBK编码
 * 默认使用UTF-8
 */

class SmsClient {
    private $userid;
    private $account;
    private $password;
    private $baseUrlUtf8 = 'http://cloud.thinksms.cn/sms.aspx';
    private $baseUrlGbk = 'http://cloud.thinksms.cn/smsGBK.aspx';
    private $statusUrl = 'http://cloud.thinksms.cn/statusApi.aspx';
    private $replyUrl = 'http://cloud.thinksms.cn/callApi.aspx';

    /**
     * 构造函数
     * @param string $userid 企业ID
     * @param string $account 账号
     * @param string $password 密码
     */
    public function __construct($userid, $account, $password) {
        $this->userid = $userid;
        $this->account = $account;
        $this->password = $password;
    }

    /**
     * 发送HTTP POST请求
     * @param string $url 请求地址
     * @param array $params 请求参数
     * @return array 解码后的JSON响应
     */
    private function sendRequest($url, $params) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response, true);
    }

    /**
     * 获取基础参数
     * @param string $action 操作类型
     * @return array
     */
    private function getBaseParams($action) {
        return [
            'userid' => $this->userid,
            'account' => $this->account,
            'password' => $this->password,
            'action' => $action,
            'rt' => 'json'
        ];
    }
}