<?php
/**
 * 文件: get_balance.php
 * 功能: 查询账户余额和发送量
 * 编码: UTF-8 (默认) / GBK
 */

require_once 'SmsClient.php';

class GetBalance extends SmsClient {
    
    /**
     * 查询账户余额和已发送量
     * @param bool $useGbk 是否使用GBK编码 (默认使用UTF-8)
     * @return array 接口返回结果
     */
    public function query($useGbk = false) {
        $params = $this->getBaseParams('overage');
        
        $url = $useGbk ? $this->baseUrlGbk : $this->baseUrlUtf8;
        
        return $this->sendRequest($url, $params);
    }
}

// 使用示例
/*
$client = new GetBalance('your_userid', 'your_account', 'your_password');
$balance = $client->query();
print_r($balance);
*/