<?php
/**
 * 文件: get_report.php
 * 功能: 获取短信发送状态报告
 * 编码: 仅此接口，与内容编码无关
 */

require_once 'SmsClient.php';

class GetReport extends SmsClient {
    
    /**
     * 获取短信发送状态报告
     * @param int $statusNum 每次获取的号码数量 (默认4000)
     * @return array 接口返回结果，包含状态报告数组
     */
    public function get($statusNum = 4000) {
        $params = $this->getBaseParams('query');
        $params['statusNum'] = $statusNum;
        
        return $this->sendRequest($this->statusUrl, $params);
    }
}

// 使用示例
/*
$client = new GetReport('your_userid', 'your_account', 'your_password');
$reports = $client->get();
print_r($reports);
*/