<?php
/**
 * 文件: send_sms.php
 * 功能: 发送短信
 * 编码: UTF-8 (默认) / GBK
 */

require_once 'SmsClient.php';

class SendSms extends SmsClient {
    
    /**
     * 发送短信
     * @param string|array $mobile 接收号码，支持单个或多个（数组或英文逗号分隔）
     * @param string $content 短信内容 (需包含签名，如【智想云创】)
     * @param string $sendTime 定时发送时间，格式：YYYY-MM-DD HH:MM:SS，为空则立即发送
     * @param string $extno 扩展子号（可选）
     * @param bool $useGbk 是否使用GBK编码 (默认使用UTF-8)
     * @return array 接口返回结果
     */
    public function send($mobile, $content, $sendTime = '', $extno = '', $useGbk = false) {
        // 格式化手机号
        if (is_array($mobile)) {
            $mobile = implode(',', $mobile);
        }
        
        $params = $this->getBaseParams('send');
        $params['mobile'] = $mobile;
        $params['content'] = $content;
        $params['sendTime'] = $sendTime;
        $params['extno'] = $extno;
        
        $url = $useGbk ? $this->baseUrlGbk : $this->baseUrlUtf8;
        
        return $this->sendRequest($url, $params);
    }
}

// 使用示例
/*
$client = new SendSms('your_userid', 'your_account', 'your_password');
$result = $client->send('13800138000', '【智想云创】您的注册验证码：8899');
print_r($result);
*/