"""
企信通短信发送接口 - Python 示例
基于 HTTP POST + UTF-8 接口
文档参考：短信接口Http1.0_明文密码.doc
"""

import requests

# ================== 配置参数（请修改为你的实际信息）==================
config = {
    'userid': 'YOUR_USERID',           # 企业ID（后台：客户管理 -> 我的信息）
    'account': 'YOUR_ACCOUNT',         # 短信账号
    'password': 'YOUR_PASSWORD',       # 登录密码（明文）
    'mobile': '13800138000',           # 接收号码，多个用英文逗号分隔，如 "13800138000,15900159000"
    'content': '【智想云创】您的注册验证码：8899',  # 短信内容，必须包含签名
    'sendTime': '',                    # 定时时间，格式：YYYY-MM-DD HH:MM:SS，留空为立即发送
    'extno': '',                       # 扩展子号（可选）
}

# 固定参数
data = {
    'action': 'send',       # 固定值：send
    'rt': 'json'            # 返回格式：json（不填默认为XML）
}
data.update(config)  # 合并配置

# 接口地址（UTF-8）
url = 'http://cloud.thinksms.cn/sms.aspx'

# ================== 发送 POST 请求 ==================
try:
    response = requests.post(
        url,
        data=data,
        headers={'Content-Type': 'application/x-www-form-urlencoded'},
        timeout=10  # 设置超时时间
    )

    # 确保编码正确（防止中文乱码）
    response.encoding = 'utf-8'

    # 解析返回的 JSON
    result = response.json()

    """
    📌 返回值说明（参考文档 1.3）：
    
    ReturnStatus: str
        - "Success"：请求提交成功（不代表短信送达）
        - "Faild"：   提交失败
    
    Message: str
        - "ok"：提交成功
        - "用户名或密码错误"：账号或密码不正确
        - "短信内容不能为空"：content 为空
        - "包含非法字符"：内容含敏感词或SQL注入字符
        - "对不起，您当前要发送的量大于您当前余额"：余额不足
        - 其他错误提示...
    
    RemainPoint: int
        - 当前账户剩余短信条数（余额）
    
    TaskID: int
        - 本次发送任务的唯一ID，可用于查询状态报告或上行
    
    SuccessCounts: int
        - 成功提交的手机号数量（如发送3个有效号码，返回3）
    """

    print("【短信发送响应】")
    print(result)

    """
    ✅ 示例成功返回：
    {
        "ReturnStatus": "Success",
        "Message": "ok",
        "RemainPoint": 109346,
        "TaskID": 365,
        "SuccessCounts": 2
    }

    ❌ 示例失败返回：
    {
        "ReturnStatus": "Faild",
        "Message": "用户名或密码错误"
    }
    """

except requests.exceptions.RequestException as e:
    print("【网络请求异常】", str(e))
except ValueError as e:
    print("【JSON解析失败】", e)
    print("原始响应内容：", response.text)