#!/usr/bin/env ruby
# -*- coding: utf-8 -*-

=begin
  企信通短信发送接口 - Ruby 示例
  基于 HTTP POST + UTF-8 接口
  文档参考：短信接口Http1.0_明文密码.doc
=end

require 'net/http'
require 'uri'
require 'json'

# ================== 配置参数（请修改为你的实际信息）==================
config = {
  userid:   'YOUR_USERID',           # 企业ID（后台：客户管理 -> 我的信息）
  account:  'YOUR_ACCOUNT',          # 短信账号
  password: 'YOUR_PASSWORD',         # 登录密码（明文）
  mobile:   '13800138000',           # 接收号码，多个用英文逗号分隔
  content:  '【智想云创】您的注册验证码：8899', # 短信内容，必须包含签名
  sendTime: '',                      # 定时发送时间，格式：YYYY-MM-DD HH:MM:SS，留空为立即发送
  extno:    '',                      # 扩展子号（可选）
}

# 固定参数
params = {
  action: 'send',       # 固定值：send
  rt:     'json'        # 返回格式：json
}

# 合并请求参数
payload = params.merge(config)

# 接口地址（UTF-8）
url = URI('http://cloud.thinksms.cn/sms.aspx')

# ================== 构建并发送 POST 请求 ==================
begin
  http = Net::HTTP.new(url.host, url.port)
  http.open_timeout = 10
  http.read_timeout  = 10

  request = Net::HTTP::Post.new(url.path)
  request['Content-Type'] = 'application/x-www-form-urlencoded'

  # 将参数编码为 form-data 格式（UTF-8）
  request.body = URI.encode_www_form(payload)

  response = http.request(request)

  # 解析响应体
  result = JSON.parse(response.body)

  =begin
    📌 返回值说明（参考文档 1.3）：

    ReturnStatus: String
      - "Success"：请求提交成功
      - "Faild"：   提交失败

    Message: String
      - "ok"：提交成功
      - "用户名或密码错误"：账号或密码不正确
      - "短信内容不能为空"：content 为空
      - "包含非法字符"：内容含敏感词或SQL注入字符
      - "对不起，您当前要发送的量大于您当前余额"：余额不足
      - 其他错误提示...

    RemainPoint: Integer
      - 当前账户剩余短信条数（余额）

    TaskID: Integer
      - 本次发送任务的唯一ID，可用于查询状态报告或上行

    SuccessCounts: Integer
      - 成功提交的手机号数量（如发送3个有效号码，返回3）
  =end

  puts "【短信发送响应】"
  puts result

  =begin
    ✅ 示例成功返回：
    {
      "ReturnStatus" => "Success",
      "Message"      => "ok",
      "RemainPoint"  => 109346,
      "TaskID"       => 365,
      "SuccessCounts"=> 2
    }

    ❌ 示例失败返回：
    {
      "ReturnStatus" => "Faild",
      "Message"      => "用户名或密码错误"
    }
  =end

rescue StandardError => e
  puts "【请求异常】 #{e.message}"
end