const crypto = require('crypto');
const axios = require('axios');

class EmptyNumberBatchDetector {
    constructor(hashcode, privateKey) {
        this.apiUrl = 'http://ip:port/HrmApi/emptyStatusQuery_batch';
        this.hashcode = hashcode;
        this.privateKey = privateKey;
    }

    _generateSign(date) {
        const hash = crypto.createHash('md5');
        hash.update(this.hashcode + this.privateKey + date);
        return hash.digest('hex');
    }

    async _sendRequest(mobiles) {
        const date = new Date().toISOString().slice(0, 10).replace(/-/g, '');
        const sign = this._generateSign(date);
        
        const payload = {
            mobiles,
            hashcode: this.hashcode,
            sign
        };

        try {
            const response = await axios.post(this.apiUrl, payload, {
                headers: { 'Content-Type': 'application/json' }
            });
            return response.data;
        } catch (error) {
            throw new Error(`Request failed: ${error.message}`);
        }
    }

    async detect(phoneNumbers) {
        const results = [];
        const chunkSize = 1000;

        for (let i = 0; i < phoneNumbers.length; i += chunkSize) {
            const chunk = phoneNumbers.slice(i, i + chunkSize);
            const response = await this._sendRequest(chunk);

            if (response.errorRes.err_code === 200) {
                results.push(...response.mobileresult);
            } else {
                throw new Error(`API Error: ${response.errorRes.err_content}`);
            }
        }

        return results;
    }
}

// 使用示例
(async () => {
    const detector = new EmptyNumberBatchDetector('your_hashcode', 'your_private_key');
    const phoneNumbers = ['13111111111', '13222222222']; // 手机号数组
    
    try {
        const results = await detector.detect(phoneNumbers);
        console.log(results);
    } catch (error) {
        console.error('Error:', error.message);
    }
})();