using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;

public class EmptyNumberBatchDetector
{
    private readonly string apiUrl = "http://ip:port/HrmApi/emptyStatusQuery_batch";
    private readonly string hashcode;
    private readonly string privateKey;
    private readonly HttpClient httpClient;

    public EmptyNumberBatchDetector(string hashcode, string privateKey)
    {
        this.hashcode = hashcode;
        this.privateKey = privateKey;
        this.httpClient = new HttpClient();
    }

    private string GenerateSign(string date)
    {
        string input = hashcode + privateKey + date;
        using (MD5 md5 = MD5.Create())
        {
            byte[] inputBytes = Encoding.UTF8.GetBytes(input);
            byte[] hashBytes = md5.ComputeHash(inputBytes);
            
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < hashBytes.Length; i++)
            {
                sb.Append(hashBytes[i].ToString("x2"));
            }
            return sb.ToString();
        }
    }

    private async Task<Dictionary<string, object>> SendRequest(List<string> mobiles)
    {
        string date = DateTime.Now.ToString("yyyyMMdd");
        string sign = GenerateSign(date);

        var requestData = new
        {
            mobiles,
            hashcode,
            sign
        };

        var content = new StringContent(JsonConvert.SerializeObject(requestData), Encoding.UTF8, "application/json");
        HttpResponseMessage response = await httpClient.PostAsync(apiUrl, content);
        string responseString = await response.Content.ReadAsStringAsync();
        return JsonConvert.DeserializeObject<Dictionary<string, object>>(responseString);
    }

    public async Task<List<Dictionary<string, object>>> Detect(List<string> phoneNumbers)
    {
        List<Dictionary<string, object>> results = new List<Dictionary<string, object>>();
        int chunkSize = 1000;

        for (int i = 0; i < phoneNumbers.Count; i += chunkSize)
        {
            int count = Math.Min(chunkSize, phoneNumbers.Count - i);
            List<string> chunk = phoneNumbers.GetRange(i, count);

            var response = await SendRequest(chunk);
            var errorRes = JsonConvert.DeserializeObject<Dictionary<string, object>>(response["errorRes"].ToString());
            
            if (errorRes["err_code"].ToString() == "200")
            {
                var mobileResults = JsonConvert.DeserializeObject<List<Dictionary<string, object>>>(response["mobileresult"].ToString());
                results.AddRange(mobileResults);
            }
            else
            {
                throw new Exception($"API Error: {errorRes["err_content"]}");
            }
        }

        return results;
    }

    // 使用示例
    public static async Task Main(string[] args)
    {
        var detector = new EmptyNumberBatchDetector("your_hashcode", "your_private_key");
        var phoneNumbers = new List<string> { "13111111111", "13222222222" }; // 手机号列表
        
        try
        {
            var results = await detector.Detect(phoneNumbers);
            Console.WriteLine(JsonConvert.SerializeObject(results, Formatting.Indented));
        }
        catch (Exception ex)
        {
            Console.WriteLine($"Error: {ex.Message}");
        }
    }
}