import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import com.google.gson.Gson;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.*;

public class EmptyNumberBatchDetector {
    private String apiUrl = "http://ip:port/HrmApi/emptyStatusQuery_batch";
    private String hashcode;
    private String privateKey;
    private Gson gson = new Gson();

    public EmptyNumberBatchDetector(String hashcode, String privateKey) {
        this.hashcode = hashcode;
        this.privateKey = privateKey;
    }

    private String generateSign(String date) throws Exception {
        String input = hashcode + privateKey + date;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(input.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private Map<String, Object> sendRequest(List<String> mobiles) throws Exception {
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String sign = generateSign(date);

        Map<String, Object> requestData = new HashMap<>();
        requestData.put("mobiles", mobiles);
        requestData.put("hashcode", hashcode);
        requestData.put("sign", sign);

        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(apiUrl);
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity(new StringEntity(gson.toJson(requestData)));

        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity);
            return gson.fromJson(result, Map.class);
        }
    }

    public List<Map<String, Object>> detect(List<String> phoneNumbers) throws Exception {
        List<Map<String, Object>> results = new ArrayList<>();
        int chunkSize = 1000;

        for (int i = 0; i < phoneNumbers.size(); i += chunkSize) {
            int end = Math.min(phoneNumbers.size(), i + chunkSize);
            List<String> chunk = phoneNumbers.subList(i, end);

            Map<String, Object> response = sendRequest(chunk);
            Map<String, Object> errorRes = (Map<String, Object>) response.get("errorRes");
            if ("200".equals(errorRes.get("err_code").toString())) {
                results.addAll((List<Map<String, Object>>) response.get("mobileresult"));
            } else {
                throw new Exception("API Error: " + errorRes.get("err_content"));
            }
        }

        return results;
    }

    // 使用示例
    public static void main(String[] args) {
        EmptyNumberBatchDetector detector = new EmptyNumberBatchDetector("your_hashcode", "your_private_key");
        List<String> phoneNumbers = Arrays.asList("13111111111", "13222222222"); // 手机号列表
        
        try {
            List<Map<String, Object>> results = detector.detect(phoneNumbers);
            System.out.println(results);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}