<?php
class EmptyNumberBatchDetector {
    private $apiUrl = 'http://ip:port/HrmApi/emptyStatusQuery_batch';
    private $hashcode;
    private $privateKey;
    
    public function __construct($hashcode, $privateKey) {
        $this->hashcode = $hashcode;
        $this->privateKey = $privateKey;
    }
    
    private function generateSign($date) {
        return md5($this->hashcode . $this->privateKey . $date);
    }
    
    private function sendRequest($mobiles) {
        $date = date('Ymd');
        $sign = $this->generateSign($date);
        
        $data = [
            'mobiles' => $mobiles,
            'hashcode' => $this->hashcode,
            'sign' => $sign
        ];
        
        $options = [
            'http' => [
                'header'  => "Content-type: application/json\r\n",
                'method'  => 'POST',
                'content' => json_encode($data),
            ],
        ];
        
        $context  = stream_context_create($options);
        $result = file_get_contents($this->apiUrl, false, $context);
        
        return json_decode($result, true);
    }
    
    public function detect($phoneNumbers) {
        $results = [];
        $chunks = array_chunk($phoneNumbers, 1000);
        
        foreach ($chunks as $chunk) {
            $response = $this->sendRequest($chunk);
            if ($response['errorRes']['err_code'] == 200) {
                $results = array_merge($results, $response['mobileresult']);
            } else {
                throw new Exception("API Error: " . $response['errorRes']['err_content']);
            }
        }
        
        return $results;
    }
}

// 使用示例
$detector = new EmptyNumberBatchDetector('your_hashcode', 'your_private_key');
$phoneNumbers = ['13111111111', '13222222222', ...]; // 手机号数组
try {
    $results = $detector->detect($phoneNumbers);
    print_r($results);
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>